module.exports = function(grunt) {

  grunt.initConfig({

    clean: {
      options: {
        force: true
      },
      pre: ["distribution"],
    },

    copy: {
      app: {
        files: [
          {expand: true, flatten: true, src: ['src/fonts/**'], dest: 'distribution/fonts/', filter: 'isFile'},
          {expand: true, flatten: true, src: ['src/img/**'], dest: 'distribution/img/', filter: 'isFile'},
          {expand: true, flatten: true, src: ['src/js/**'], dest: 'distribution/js/', filter: 'isFile'}
        ]
      }
    },

    concat: {

    },

    includereplace: {
      dist: {
        files: [
          { src: '*.html', dest: 'distribution/', expand: true, cwd: 'src/html/'}
        ]
      }
    },

    sass: {
      dev: {
        options: {
          style: 'expanded'
        },
        files: {
          'distribution/stylesheet.css': 'src/scss/styles.scss'
        }
      },
      build: {
        options: {
          style: 'compress'
        },
        files: {
          'distribution/stylesheet.css': 'src/scss/styles.scss'
        }
      }
    },

    uglify: {
      app: {
        options: {
          mangle: false
        },
        files: {
          'distribution/scripts.js': ['distribution/scripts.js'],
        }
      }
    },

    connect: {
      build: {
        options: {
          hostname: '127.0.0.1',
          port: 8080,
          base: 'distribution/',
          open: true,
          livereload: true
        }
      }
    },

    watch: {
      options: {
        livereload: true
      },
      build: {
        files: ['src/**/*'],
        tasks: ['copy', 'includereplace', 'sass']
      },
    }

  });

  grunt.loadNpmTasks('grunt-contrib-clean');        // https://github.com/gruntjs/grunt-contrib-clean

  grunt.loadNpmTasks('grunt-contrib-copy');         // https://github.com/gruntjs/grunt-contrib-copy
  grunt.loadNpmTasks('grunt-contrib-concat');       // https://github.com/gruntjs/grunt-contrib-concat
  grunt.loadNpmTasks('grunt-contrib-sass');         // https://github.com/gruntjs/grunt-contrib-sass
  grunt.loadNpmTasks('grunt-include-replace');      // https://github.com/alanshaw/grunt-include-replace
  grunt.loadNpmTasks('grunt-contrib-uglify');       // https://github.com/gruntjs/grunt-contrib-uglify

  grunt.loadNpmTasks('grunt-contrib-connect');      // https://github.com/gruntjs/grunt-contrib-connect
  grunt.loadNpmTasks('grunt-contrib-watch');        // https://github.com/gruntjs/grunt-contrib-watch


  grunt.registerTask('build', ['clean', 'copy', 'includereplace', 'sass:build', 'uglify']);

  grunt.registerTask('dev', ['clean', 'copy', 'includereplace', 'sass:dev', 'uglify', 'connect', 'watch']);


};
