<?php get_header(); ?>

<section id="content" role="main" class='container'>
  <header class="header">
    <h1 class="entry-title">GLS Webinars</h1>
  </header>
  <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
    <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

      <section class="entry-content">
        <?php the_content(); ?>

        <?php $add_forms = get_field('add_forms');?>
        <?php if($add_forms):?>
          <div class='contact-forms'>
            <?php echo $add_forms;?>
          </div>
        <?php endif; ?>
        <div class="entry-links"><?php wp_link_pages(); ?></div>
      </section>
    </article>
    <?php

    ?>

  <?php endwhile; endif; ?>
  <div class='row gls-web island-bottom'>

    <?php
    $loop = new WP_Query( array(
      'post_type' => 'gls_webinars',
      'posts_per_page' => -1 ) );
      ?>
      <?php while ( $loop->have_posts() ) : $loop->the_post(); ?>
        <?php //Var
        $main_description = get_field('main_description');
        $teaser_description = get_field('teaser_description');
        $transcript_attachment = get_field('transcript_attachment');
        $mp3_audio_attachment = get_field('mp3_audio_attachment');
        $care_resources = get_field('care_resources');
        $featured_image_area = get_field('featured_image_area');
        ?>
        <div class='col-12 col-4-m island-bottom-margin'>
          <div class='inner' data-match-height="web-height">
            <a href='<?php the_permalink(); ?>'>
              <?php if($featured_image_area):?>
                <div class='img island-half-bottom'>
                  <img class='full-width' src="<?php echo $featured_image_area['url'];?>" />
                </div>
              <?php endif; ?>

              <h2 class='island-half' data-match-height="title-height"><?php echo $post->post_title; ?></h2>
              <?php if($teaser_description):?>
                <div class='description' data-match-height="desc-height">
                  <?php echo $teaser_description; ?>
                </div>
              <?php endif; ?>
            </a>
          </div>
        </div>

      <?php endwhile; wp_reset_query(); ?>

    </div>
  </section>



  <?php get_footer(); ?>
  <!--archive-gls_webinanrs-->
